# Player: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B (as Player B)
# Meta-Round: 4
# Experiment: PMxPM, Run: 2
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek_V3_0324_PayoffMaximizer_B_MR4_strategy.txt
# LLM Suggested Fallback: D

def huggingface_DeepSeek_V3_0324_PayoffMaximizer_B_MR4(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    current_round = len(my_history) + 1
    total_rounds = 10
    
    # Check for unconditional defection in opponent's code
    if "always D" in opponent_program_code or "return 'D'" in opponent_program_code:
        return "D"
    
    # Check for unconditional cooperation in opponent's code
    if "always C" in opponent_program_code or "return 'C'" in opponent_program_code:
        if current_round == 1:
            return "C"
        else:
            return "D"
    
    # First round: Cooperate to build trust
    if current_round == 1:
        return "C"
    
    # Check if opponent has defected more than twice in a row
    if len(opp_history) >= 3 and all(move == "D" for move in opp_history[-3:]):
        return "D"
    
    # Check if opponent has cooperated consistently (>=70%)
    coop_rate = sum(1 for move in opp_history if move == "C") / len(opp_history)
    if coop_rate >= 0.7:
        return "C"
    
    # Last 2 rounds: Defect if opponent has defected at least once in past 5 rounds
    if current_round >= total_rounds - 1:
        if len(opp_history) >= 5 and "D" in opp_history[-5:]:
            return "D"
        else:
            return "C"
    
    # Tit-for-Tat with 10% chance of random cooperation
    last_opp_move = opp_history[-1]
    if last_opp_move == "C":
        return "C"
    else:
        if random.random() < 0.1:
            return "C"
        else:
            return "D"